//Program Title: Image Enhancement - Image Histogram Equalisation
//For Gray Image
//Software version
//For: OS Windows7 and 8
//Scilab5.4.1 and above
//Image Processing Design Toolbox 8.3.1 and above
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2 and above
//For: OS Ubuntu Linux 14.04 and above
//Scilab5.5.1 
//Image Processing Design Toolbox 8.3.1 and above
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2 and above
//To read and write in the correct folder
//change the current directory in scilab console

clc;
clear all;

f=ReadImage('Exp5pout.jpg');// Get image (Keep image file in same folder)
OrigSize=size(f);//Get size of original image
OrigRow=OrigSize(1);//Get number of rows in original image
OrigCol=OrigSize(2);//Get number of colomns in original image

figure
ShowImage(f,'Original Image Pout')
WriteImage(f,'Exp6OriginalImagePout.jpg') //Comment out if you do not want o/p file to be written on disk

OrigHist=CreateHistogram(uint8(f));//Create Histogram
figure
plot2d3(OrigHist)//Show Histogram
title('Original Image Histogram')

P=OrigHist/(OrigRow*OrigCol);//get average pixel value

C=zeros(1,256);

for i=2:256
    C(1,i)=C(1,i-1)+P(1,i);
end

Cdash = round(C*255);

EqImage=[]//Empty matrix for output image
for i=1:OrigRow
    for j=1:OrigCol
        EqImage(i,j)=Cdash(1,f(i,j)+1);
    end
end

figure
ShowImage(uint8(EqImage),'Image Histogram Equalisation')
WriteImage(uint8(EqImage),'Exp6ImageHistogramEqualisation.jpg') //Comment out if you do not want o/p file to be written on disk

EqHist=CreateHistogram(uint8(EqImage));//Create Histogram
figure
plot2d3(EqHist)//Show Histogram
title('Histogram Equalized Image')
